# generic procs for Navision. Used by fym

proc fym_nav2013:xml:encode {s} {
	return [string map {> &gt; < &lt; & &amp; \" &quot; ' &apos;} $s]
}

proc fym_nav2013:xml:decode {s} {
	return [string map {&gt; > &lt; < &amp; & &quot; \" &apos; '} $s]
}

proc fym_nav2013:xml:get_values_from_key {key xml} {
	set values {}
	
	while {[set i [string first "<${key}>" $xml]] != -1} {
		
		set tmp [string range $xml $i end]
		set tmp [string range $tmp [string length "<${key}>"] [string first "</${key}>" $tmp]-1]
		
		lappend values $tmp
		
		set xml [string range $xml [string first "</${key}>" $xml]+[string length "</${key}>"] end]
	}

	return $values
}


proc fym_nav2013:xml:get_value_from_key {key xml} {
	
	set tmp [string range $xml [string first "<${key}>" $xml] end]
	set tmp [string range $tmp [string length "<${key}>"] [string first "</${key}>" $tmp]-1]
	return [fym_nav2013:xml:decode $tmp]
}

